%sigma-epsilon
fc=[32.8,36.5];
ec=[27.12d9,30.76d9];
C=1.2-0.006.*fc;
e0=(7.0d-4).*fc.^(1/3);
B=(260+100./fc);
A=ec.*e0./fc;
e1a=[1.0d-6:1.0d-6:e0(1)];
e1b=[1.0d-6:1.0d-6:e0(2)];
sigmaup1=fc(1).*(A(1).*(e1a./e0(1))-(A(1)-1).*((e1a./e0(1)).^(A(1)/(A(1)-1))));
sigmaup2=fc(2).*(A(2).*(e1b./e0(2))-(A(2)-1).*((e1b./e0(2)).^(A(2)/(A(2)-1))));
e2a=e0(1):1.0d-6:0.005;
e2b=e0(2):1.0d-6:0.005;
sigmadown1=fc(1).*exp(-B(1).*(e2a-e0(1)).^C(1));
sigmadown2=fc(2).*exp(-B(2).*(e2b-e0(2)).^C(2));
ea=[e1a,e2a];
eb=[e1b,e2b];
sigmaline=[sigmaup1,sigmadown1];
sigmaline2=[sigmaup2,sigmadown2];
% plot(eb,sigmaline2,'b')
plot(ea,sigmaline,'b')
hold on
xlabel('Strain')
ylabel('Stress (MPa)')
grid on
set(gca,'FontSize',16,'FontName','Times New Roman');
plot(e1a,ec(1).*(e1a)./1.0d6)
% plot(e1b,ec(2).*(e1b)./1.0d6)
% plot(e1b,sigmaup2,'b')
% hold on
% plot(e2b,sigmadown2,'b')
% hold on
%% ΪԱ
sig1=25.95;
sig2=fc(1);
sig3=16.15;
eps1=0.000957;
eps2=0.002235;
eps3=0.005;
k1=sig1/eps1;
k2=(sig2-sig1)/(eps2-eps1);
k3=abs((sig3-sig2)/(eps3-eps2));
%
e1=1.0d-6:1.0d-7:eps1;
e2=eps1:1.0d-7:eps2;
e3=eps2:1.0d-7:0.005;
sigmaup1=e1.*k1;
sigmaup2=sig1 + (e2-eps1).*k2;
sigmadown=sig2-(e3-eps2).*k3;
e=[e1,e2,e3];
sigma=[sigmaup1,sigmaup2,sigmadown];
plot(e,sigma,'g')
xlabel('Strain')
ylabel('Stress (MPa)')
grid on
set(gca,'FontSize',16,'FontName','Times New Roman');