function [node, element] = c3d27(a, ndiv)
% author: Ji Wan, Wuhan University, Email: wanji@whu.edu.cn
% date: 2021-06-25
% date: 2021-06-29 renamed from rectC3D27 to c3d27
npx = 2*ndiv(1)+1;
npy = 2*ndiv(2)+1;
npz = 2*ndiv(3)+1;
x = linspace(0, a(1), npx);
y = linspace(0, a(2), npy);
z = linspace(0, a(3), npz);
[x, y, z] = meshgrid(x, y, z);
x1 = 1:2:npx-1;
x2 = 2:2:npx;
x3 = 3:2:npx;
y1 = 1:2:npy-1;
y2 = 2:2:npy;
y3 = 3:2:npy;
z1 = 1:2:npz-1;
z2 = 2:2:npz;
z3 = 3:2:npz;
% 27 nodes
[p, q, r] = meshgrid(1:npy, 1:npx, 1:npz);
p1 = sub2ind([npy, npx, npz], p(x1,y1,z1), q(x1,y1,z1), r(x1,y1,z1));
p2 = sub2ind([npy, npx, npz], p(x3,y1,z1), q(x3,y1,z1), r(x3,y1,z1));
p3 = sub2ind([npy, npx, npz], p(x3,y3,z1), q(x3,y3,z1), r(x3,y3,z1));
p4 = sub2ind([npy, npx, npz], p(x1,y3,z1), q(x1,y3,z1), r(x1,y3,z1));
p5 = sub2ind([npy, npx, npz], p(x1,y1,z3), q(x1,y1,z3), r(x1,y1,z3));
p6 = sub2ind([npy, npx, npz], p(x3,y1,z3), q(x3,y1,z3), r(x3,y1,z3));
p7 = sub2ind([npy, npx, npz], p(x3,y3,z3), q(x3,y3,z3), r(x3,y3,z3));
p8 = sub2ind([npy, npx, npz], p(x1,y3,z3), q(x1,y3,z3), r(x1,y3,z3));
p9 = sub2ind([npy, npx, npz], p(x2,y1,z1), q(x2,y1,z1), r(x2,y1,z1));
p10 = sub2ind([npy, npx, npz], p(x3,y2,z1), q(x3,y2,z1), r(x3,y2,z1));
p11 = sub2ind([npy, npx, npz], p(x2,y3,z1), q(x2,y3,z1), r(x2,y3,z1));
p12 = sub2ind([npy, npx, npz], p(x1,y2,z1), q(x1,y2,z1), r(x1,y2,z1));
p13 = sub2ind([npy, npx, npz], p(x2,y1,z3), q(x2,y1,z3), r(x2,y1,z3));
p14 = sub2ind([npy, npx, npz], p(x3,y2,z3), q(x3,y2,z3), r(x3,y2,z3));
p15 = sub2ind([npy, npx, npz], p(x2,y3,z3), q(x2,y3,z3), r(x2,y3,z3));
p16 = sub2ind([npy, npx, npz], p(x1,y2,z3), q(x1,y2,z3), r(x1,y2,z3));
p17 = sub2ind([npy, npx, npz], p(x1,y1,z2), q(x1,y1,z2), r(x1,y1,z2));
p18 = sub2ind([npy, npx, npz], p(x3,y1,z2), q(x3,y1,z2), r(x3,y1,z2));
p19 = sub2ind([npy, npx, npz], p(x3,y3,z2), q(x3,y3,z2), r(x3,y3,z2));
p20 = sub2ind([npy, npx, npz], p(x1,y3,z2), q(x1,y3,z2), r(x1,y3,z2));
p21 = sub2ind([npy, npx, npz], p(x2,y1,z2), q(x2,y1,z2), r(x2,y1,z2));
p22 = sub2ind([npy, npx, npz], p(x3,y2,z2), q(x3,y2,z2), r(x3,y2,z2));
p23 = sub2ind([npy, npx, npz], p(x2,y3,z2), q(x2,y3,z2), r(x2,y3,z2));
p24 = sub2ind([npy, npx, npz], p(x1,y2,z2), q(x1,y2,z2), r(x1,y2,z2));
p25 = sub2ind([npy, npx, npz], p(x2,y2,z1), q(x2,y2,z1), r(x2,y2,z1));
p26 = sub2ind([npy, npx, npz], p(x2,y2,z3), q(x2,y2,z3), r(x2,y2,z3));
p27 = sub2ind([npy, npx, npz], p(x2,y2,z2), q(x2,y2,z2), r(x2,y2,z2));
element = [p1(:), p2(:), p3(:), p4(:), p5(:), p6(:), p7(:), p8(:), p9(:), p10(:),...
    p11(:), p12(:), p13(:), p14(:), p15(:), p16(:), p17(:), p18(:), p19(:), p20(:),...
    p21(:), p22(:), p23(:), p24(:), p25(:), p26(:), p27(:)];
node = [x(:), y(:), z(:)];
end


