function [node, element] = c3d8(a, ndiv)
% author: Ji Wan, Wuhan University, Email: wanji@whu.edu.cn
% date: 2021-06-25
% date: 2021-06-29 Renamed From rectC3D8 to c3d8
x = linspace(0, a(1), ndiv(1)+1);
y = linspace(0, a(2), ndiv(2)+1);
z = linspace(0, a(3), ndiv(3)+1);
[x, y, z] = meshgrid(x, y, z);
% 8 nodes
nx = ndiv(1)+1;
ny = ndiv(2)+1;
nz = ndiv(3)+1;
[p, q, r] = meshgrid(1:ny, 1:nx, 1:nz);
p1 = sub2ind([ny, nx, nz], p(1:nx-1, 1:ny-1, 1:nz-1), q(1:nx-1, 1:ny-1, 1:nz-1), r(1:nx-1, 1:ny-1, 1:nz-1));
p2 = sub2ind([ny, nx, nz], p(2:nx,1:ny-1, 1:nz-1), q(2:nx,1:ny-1, 1:nz-1), r(2:nx,1:ny-1, 1:nz-1));
p3 = sub2ind([ny, nx, nz], p(2:nx, 2:ny, 1:nz-1), q(2:nx, 2:ny, 1:nz-1), r(2:nx, 2:ny, 1:nz-1));
p4 = sub2ind([ny, nx, nz], p(1:nx-1,2:ny, 1:nz-1), q(1:nx-1,2:ny, 1:nz-1), r(1:nx-1,2:ny, 1:nz-1));
p5 = sub2ind([ny, nx, nz], p(1:nx-1, 1:ny-1, 2:nz), q(1:nx-1, 1:ny-1, 2:nz), r(1:nx-1, 1:ny-1, 2:nz));
p6 = sub2ind([ny, nx, nz], p(2:nx,1:ny-1, 2:nz), q(2:nx,1:ny-1, 2:nz), r(2:nx,1:ny-1, 2:nz));
p7 = sub2ind([ny, nx, nz], p(2:nx, 2:ny, 2:nz), q(2:nx, 2:ny, 2:nz), r(2:nx, 2:ny, 2:nz));
p8 = sub2ind([ny, nx, nz], p(1:nx-1,2:ny, 2:nz), q(1:nx-1,2:ny, 2:nz), r(1:nx-1,2:ny, 2:nz));
element = [p1(:), p2(:), p3(:), p4(:), p5(:), p6(:), p7(:), p8(:)];
node = [x(:) y(:) z(:)];
end

