
clc; clear
M = [
    1940	914.1141
    1941	892.5171
    1942	886.9780
    1943	882.1540
    1944	970.8711
    1945	1004.5173
    1946	1085.8446
    1947	1173.7540
    1948	1208.3027
    1949	1391
    1950	1471
    1951	1441
    1952	1724
    1953	1675
    1954	1851
    1955	1861
    1956	1736
    1957	1900
    1958	1714
    1959	1306
    1960	1468
    1961	1141
    1962	2092
    1963	2787
    1964	2414
    1965	2480
    1966	2483
    1967	2174
    1968	2772
    1969	2502
    1970	2801
    1971	2516
    1972	2480
    1973	2491
    1974	2255
    1975	2126
    1976	1866
    1977	1798
    1978	1757
    1979	1738
    1980	1797
    1981	2092
    1982	2265
    1983	2080
    1984	2077
    1985	2227
    1986	2411
    1987	2550
    1988	2307
    1989	2432
    1990	2391
    1991	2258
    1992	2119
    1993	2126
    1994	2104
    1995	2063
    1996	2067
    1997	2038
    1998	1991
    1999	1909
    2000	1771
    2001	1702
    2002	1647
    2003	1599
    2004	1593
    2005	1617
    2006	1584
    2007	1594
    2008	1608
    2009	1615
    2010	1588
    2011	1604
    2012	1635
    2013	1640
    2014	1687
    2015	1655
    2016	1786
    2017	1723
    2018	1523
    2019	1465
    2020	1202
    2021	1062
    2022	956
    2023    902];
N = 141175;
% alpha = 61/1.01e4;
alpha = 6.4/1000;
% alpha = 6.5e-3;
t = 2024;
i_arr = 1:100;
N_arr = zeros(size(i_arr));
expectedLifeSpan = 80;
for i = 1:100
    t80 = (i+t)-expectedLifeSpan;
%     if((i+t)>2060)
%         alpha = 17e-3;
%     end
    if(t80<M(1,1))
        Mt80 = M(1,2);
    elseif(t80<2024)
        Mt80 = M(t80-M(1,1)+1,2);
    elseif(t80==2024)
        Mt80 = 141175 * alpha;
    else
        Mt80 = N_arr(t80-2024)*alpha;
    end
    t30 = (i+t)-27;
    if(t30<M(1,1))
        Nt30 = M(1,2);
    elseif(t30<2024)
        Nt30 = M(t30-M(1,1)+1,2);
    elseif(t30==2024)
        Nt30 = 141175 * alpha;
    else
        Nt30 = N_arr(t30-2024)*alpha;
    end
    
    
    Nt30 = 1.07/2.1 * Nt30;
    [N * alpha, Nt30];
    N_arr(i) = N + (N * alpha+Nt30)/2 - Mt80;
    N = N_arr(i);
end
f1 = figure(100); 
set(f1,'Position', [100,100,1600,800])
plot(i_arr+2024, N_arr/1e4, 'b-d', 'markersize', 10, 'markerfacecolor', 'b',...
    'MarkerIndices', 1:5:100);
hold on
set(gca, 'fontsize', 14, 'fontname', 'times new roman')
set(gca, 'ytick', 0:1:15, 'xtick', 2025:5:2120,...
    'yminortick','on', 'xminortick','on');
grid on
axis([2020, 2120, 0, 15])
xlabel('年份', 'fontsize', 16, 'fontname', 'song')
ylabel('预测人口(亿)', 'fontsize', 16, 'fontname', 'song')
title('按照6.4‰出生率继续下去', 'fontsize', 16, 'fontname', 'song')
hold on


f2 = figure(200); 
set(f2,'Position', [100,100,1600,800])
plot(i_arr+2024, N_arr*alpha, 'r-s', 'markersize', 10, 'markerfacecolor', 'b',...
    'MarkerIndices', 1:5:100);
hold on
set(gca, 'fontsize', 14, 'fontname', 'times new roman')
set(gca, 'ytick', 0:100:1000, 'xtick', 2025:5:2120,...
    'yminortick','on', 'xminortick','on');
grid on
axis([2020, 2120, 0, 1000])
xlabel('年份', 'fontsize', 16, 'fontname', 'song')
ylabel('出生人口预测(万)', 'fontsize', 16, 'fontname', 'song')
title('按照6.4‰出生率继续下去', 'fontsize', 16, 'fontname', 'song')

% 劳动人口
Q = zeros(size(N_arr));
for i = 1:numel(N_arr)
    if(i<=16)
        Q(i) = sum(M(end-59+i:end-16+i,2));
    elseif(i<=59)
        Q(i) = sum(M(end-59+i:end,2)) + sum(N_arr(1:i-16)*alpha);
    else
        Q(i) = sum(N_arr(i-59:i-16)*alpha);
    end
end
Q = 86481/ Q(1) * Q ;
f3 = figure(300); 
set(f3,'Position', [100,100,1600,800])
plot(i_arr+2024, Q/1e4, 'r-s', 'markersize', 10, 'markerfacecolor', 'b',...
    'MarkerIndices', 1:5:100);
hold on
set(gca, 'fontsize', 14, 'fontname', 'times new roman')
set(gca, 'ytick', 0:1:10, 'xtick', 2025:5:2120,...
    'yminortick','on', 'xminortick','on');
grid on
axis([2020, 2120, 0, 10])
xlabel('年份', 'fontsize', 16, 'fontname', 'song')
ylabel('劳动人口预测(亿)', 'fontsize', 16, 'fontname', 'song')
title('按照6.4‰出生率继续下去', 'fontsize', 16, 'fontname', 'song')



% 老龄人口
P = zeros(size(N_arr));
Agee = 59;
for i = 1:numel(N_arr)
    if(i<=1)
        P(i) = sum(M(end-Agee+i:end-1+i,2));
    elseif(i<=Agee)
        P(i) = sum(M(end-Agee+i:end,2)) + sum(N_arr(1:i-1)*alpha);
    else
        P(i) = sum(N_arr(i-Agee:i-1)*alpha);
    end
end
 P = (N_arr-P)./N_arr ;
 P = P * 18.1/100/P(1);
f4 = figure(400); 
set(f4,'Position', [100,100,1600,800])
plot(i_arr+2024, P*1e2, 'r-s', 'markersize', 10, 'markerfacecolor', 'b',...
    'MarkerIndices', 1:5:100);
hold on
set(gca, 'fontsize', 14, 'fontname', 'times new roman')
set(gca, 'ytick', 0:5:40, 'xtick', 2025:5:2120,...
    'yminortick','on', 'xminortick','on');
grid on
axis([2020, 2120, 0, 40])
xlabel('年份', 'fontsize', 16, 'fontname', 'song')
ylabel('老龄化率(%)[60岁以上人口占比]', 'fontsize', 16, 'fontname', 'song')
title('按照6.4‰出生率继续下去', 'fontsize', 16, 'fontname', 'song')
