clc; clear
delta = 0.05;
mvalue_arr = [2, 3, 4, 5, 6, 7];
Model_I_M_Conv = struct(...
    'result', [], ...
    'mvalue', cell(size(mvalue_arr)), ...
    'ndiv', [], ...
    'gfunOrder', [], ...
    'adjustRatio', [], ...
    'Ftol', [], ...
    'Utol', [] ...
    );
saveFolder = 'result_M_convergence\';
if(~exist(saveFolder, 'dir'))
    mkdir(saveFolder);
end
for i = 1:numel(mvalue_arr)
    mvalue = mvalue_arr(i);
    ndiv = ceil(1/(delta/mvalue));
    adjustRatio = 1;
    gfunOrder = 2;
    ntMax = 1000000;
    Ftol = 1e-4;
    Utol = 1e-8;
    [X, Y, VOL, U1, U2, W3, U_L2, W_L2, F_L2, M_L2] = ...
        MP_quasistatic_Model_I_True2(mvalue, ndiv, adjustRatio, gfunOrder, ntMax, Ftol, Utol, delta);
    result.X = X;
    result.Y = Y;
    result.VOL = VOL;
    result.U1 = U1;
    result.U2 = U2;
    result.W3 = W3;
    result.U_L2 = U_L2;
    result.W_L2 = W_L2;
    result.F_L2 = F_L2; 
    result.M_L2 = M_L2;
    Model_I_M_Conv(i).result = result;
    Model_I_M_Conv(i).mvalue = mvalue;
    Model_I_M_Conv(i).ndiv =  ndiv;
    Model_I_M_Conv(i).gfunOrder = gfunOrder;
    Model_I_M_Conv(i).adjustRatio = adjustRatio;
    Model_I_M_Conv(i).Ftol = Ftol;
    Model_I_M_Conv(i).Utol = Utol;
    filename = sprintf('Model_I_M_Conv_Order%d_delta%.2f.mat', gfunOrder, delta);
    save([saveFolder,filename], "Model_I_M_Conv")
end
