clc; clear
mvalue_arr = [1, 2, 3, 4, 5];
Model_I_M_Conv = struct(...
    'result', [], ...
    'mvalue', cell(size(mvalue_arr)), ...
    'ndiv', [], ...
    'gfunOrder', [], ...
    'adjustRatio', [], ...
    'Ftol', [], ...
    'Utol', [] ...
    );
saveFolder = 'result\';
if(~exist(saveFolder, 'dir'))
    mkdir(saveFolder);
end
for i = 1:numel(mvalue_arr)
    mvalue = mvalue_arr(i);
    ndiv = 80;
    adjustRatio = 1;
    gfunOrder = 1;
    ntMax = 1000000;
    Ftol = 1e-4;
    Utol = 1e-8;
    [X, Y, VOL, U1, U2, W3, U_L2, W_L2, F_L2, M_L2] = ...
        MP_quasistatic_Model_I_True(mvalue, ndiv, adjustRatio, gfunOrder, ntMax, Ftol, Utol);
    result.X = X;
    result.Y = Y;
    result.VOL = VOL;
    result.U1 = U1;
    result.U2 = U2;
    result.W3 = W3;
    result.U_L2 = U_L2;
    result.W_L2 = W_L2;
    result.F_L2 = F_L2; 
    result.M_L2 = M_L2;
    Model_I_M_Conv(i).result = result;
    Model_I_M_Conv(i).mvalue = mvalue;
    Model_I_M_Conv(i).ndiv =  ndiv;
    Model_I_M_Conv(i).gfunOrder = gfunOrder;
    Model_I_M_Conv(i).adjustRatio = adjustRatio;
    Model_I_M_Conv(i).Ftol = Ftol;
    Model_I_M_Conv(i).Utol = Utol;
    filename = sprintf('Model_I_M_Conv_%dx%d_gOrder%d', ndiv, ndiv, gfunOrder);
    save([saveFolder,filename], "Model_I_M_Conv")
    
%     figure(400); clf
%     pcolor(X,Y,U2)
%     colormap(jet)
%     colorbar
%     axis equal
%     title('u_2')
%     pause(0.001)
%     figure(500); clf
%     pcolor(X, Y, U1)
%     colormap(jet)
%     colorbar
%     axis equal
%     title('u_1')
%     pause(0.001)
%     figure(600); clf
%     pcolor(X, Y, W3)
%     colormap(jet)
%     colorbar
%     title('\omega_z')
%     axis equal
%     pause(0.001)
%     figure(700); clf
%     plot(1:1:numel(U_L2),log10(U_L2), 'r-')
%     hold on
%     plot(1:1:numel(U_L2),log10(W_L2), 'b-')
%     xlabel('Iterations'); ylabel('L2')
%     figure(800); clf
%     plot(1:1:numel(U_L2),log10(F_L2), 'r-')
%     hold on
%     plot(1:1:numel(U_L2),log10(M_L2), 'b-')
%     xlabel('Iterations'); ylabel('L2')
%     pause(0.001)
end
