clc; clear
mvalue_arr = [2, 3, 4, 5];
Model_II_M_Conv = struct(...
    'result', [], ...
    'mvalue', cell(size(mvalue_arr)), ...
    'ndiv', [], ...
    'gfunOrder', [] ...
    );
saveFolder = 'result\';
if(~exist(saveFolder, 'dir'))
    mkdir(saveFolder);
end
for i = 1:numel(mvalue_arr)
    mvalue = mvalue_arr(i);
    ndiv = 100;
    gfunOrder = 2;
    [X, Y, VOL, U1, U2, W3] = ...
        MP_Static_Model_II(mvalue, ndiv);
    result.X = X;
    result.Y = Y;
    result.VOL = VOL;
    result.U1 = U1;
    result.U2 = U2;
    result.W3 = W3;
    Model_II_M_Conv(i).result = result;
    Model_II_M_Conv(i).mvalue = mvalue;
    Model_II_M_Conv(i).ndiv =  ndiv;
    Model_II_M_Conv(i).gfunOrder = gfunOrder;
    filename = sprintf('Model_II_M_Conv_%dx%d_gOrder%d', ndiv, ndiv, gfunOrder);
    save([saveFolder,filename], "Model_II_M_Conv")
end
