clc; clear
resultFolder = 'result\';
ndivs = 60;
gOrder = 1;
for j = 1:numel(ndivs)
    
    fileName = [resultFolder,sprintf('Model_I_M_Conv_%dx%d_gOrder%d.mat', ndivs(j), ndivs(j), gOrder)];
    
    if(~exist(fileName, 'file'))
        continue;
    end
    A = load(fileName);
    modelData = A.Model_I_M_Conv;
    for i = 3
        if(isempty(modelData(i).result))
            continue;
        end
        result = modelData(i).result;
        U_L2 = result.U_L2;
        W_L2 = result.W_L2;
        F_L2 = result.F_L2;
        M_L2 = result.M_L2;
        nt = numel(U_L2);
        niter = 1:1:nt;
        figure(700); clf
        
        semilogy(niter,U_L2(niter), 'r--', 'linewidth', 2)
        hold on
        semilogy(niter,W_L2(niter), 'b-', 'linewidth', 2)
%         xlabel('$\rm{Number\; of \; iterations}$', ...
%             'interpreter', 'latex', 'fontname', 'times new roman','fontsize', 16);
%         ylabel('$\varepsilon_{\rm{u|\theta}}$', ...
%             'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 16)
        xlabel('\fontname{song ti} 迭代次数', ...
            'fontsize', 16);
        ylabel('$\varepsilon_{\rm{F|M}}$', ...
            'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 16)
        set(gca, 'fontname', 'times new roman', 'fontsize', 16, 'xminortick', 'on', 'yminortick', 'on', ...
            'xtick',0:1000:5000, 'ytick',  10.^(-10:2:0))
        legend({'$\varepsilon_{\rm{u}}$', '$\varepsilon_{\mathrm{\theta}}$'}, ...
            'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 16)
        
        
        
        
        figure(800); clf
        semilogy(niter,F_L2(niter), 'r--', 'linewidth', 2)
        hold on
        semilogy(niter,M_L2(niter), 'b-', 'linewidth', 2)
%         xlabel('$\rm{Number\; of \; iterations}$', ...
%             'interpreter', 'latex', 'fontname', 'times new roman','fontsize', 16);
%         ylabel('$\varepsilon_{\rm{F|M}}$', ...
%             'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 16)
        xlabel('\fontname{song ti} 迭代次数', ...
            'fontsize', 16);
        ylabel('$\varepsilon_{\rm{F|M}}$', ...
            'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 16)
        
        set(gca, 'fontname', 'times new roman', 'fontsize', 16, 'xminortick', 'on', 'yminortick', 'on', ...
            'xtick',0:1000:5000, 'ytick',  10.^(-8:2:0))
        legend({'$\varepsilon_{\rm{F}}$', '$\varepsilon_{\mathrm{M}}$'}, ...
            'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 16)
    end
end




markers = {'o', 'h', 'd', '>', 'p'};
lines = {'-', '--', '-.', '-', ':'};
colors = {'r', 'g', 'b', 'k', 'm'};
