clc; clear
resultFolder = 'result\';
D = load([resultFolder,'FEMdata.mat'], 'data');
U1_fem = D.data.U1;
U2_fem = D.data.U2;
W3_fem = D.data.W3;
ndivs = [10, 20, 40, 60, 80, 100];
ErrU = zeros(numel(ndivs), 5);
ErrU2 = zeros(numel(ndivs), 5);
ErrW3 = zeros(numel(ndivs), 5);
dx = zeros(numel(ndivs), 5);
gOrder = 2;

for j = 1:numel(ndivs)
    
    fileName = [resultFolder,sprintf('Model_II_M_Conv_%dx%d_gOrder%d.mat', ndivs(j), ndivs(j), gOrder)];
    
    if(~exist(fileName, 'file'))
        continue;
    end
    A = load(fileName);
    modelData = A.Model_II_M_Conv;
    for i = 1:numel(modelData)
        if(isempty(modelData(i).result))
            continue;
        end
        result = modelData(i).result;
        X = result.X;
        Y = result.Y;
        VOL = result.VOL;
        U1 = result.U1;
        U2 = result.U2;
        W3 =  result.W3;
        mvalue = modelData(i).mvalue;
        ndiv =  modelData(i).ndiv;
        gfunOrder = modelData(i).gfunOrder;
        U1_f = U1_fem(1:1200/ndiv:end,1:1200/ndiv:end);
        U2_f = U2_fem(1:1200/ndiv:end,1:1200/ndiv:end);
        ErrU(j, i) = sqrt(sum(sum((U1-U1_f).^2+(U2-U2_f).^2))/sum(sum(U1_f.^2+U2_f.^2)));

        
        W3_f = W3_fem(1:1200/ndiv:end,1:1200/ndiv:end);
        ErrW3(j,i) = sqrt(sum(sum((W3-W3_f).^2))/sum(sum(W3_f.^2)));
        dx(j,i) = 1 / ndiv;
    end
end

markers = {'o', 'h', 'd', '>', 'p'};
lines = {'-', '--', '-.', '-', ':'};
colors = {'r', 'g', 'b', 'k', 'm'};

for j = 1:size(dx,2)
    figure(1);
    plot(log10(dx(:,j)), log10(ErrU(:,j)), [colors{j}, markers{j}, lines{j}], 'markerfacecolor', colors{j}, 'markersize', 6)
    hold on
    xlabel('$\rm{log_{10}}{\rm{\Delta}\it{x}}$', 'interpreter', 'latex', 'fontname', 'times new roman',...
        'fontsize', 16);
    ylabel('$\rm{log_{10}}{||\it{(\bf{u})}||_{\it{L}_{\rm{2}}}}$', 'interpreter', 'latex', 'fontname', 'times new roman',...
        'fontsize', 16)
    set(gca, 'fontname', 'times new roman', 'fontsize', 16, 'xminortick', 'on', 'yminortick', 'on')
    
    % p1 = polyfit(log10(dx(:,j)), log10(ErrU(:,j)), 1)

    figure(2);
    plot(log10(dx(:,j)), log10(ErrW3(:,j)), [colors{j}, markers{j}, lines{j}], 'markerfacecolor', colors{j}, 'markersize', 6)
    hold on
    xlabel('$\rm{log_{10}}{\rm{\Delta}\it{x}}$', 'interpreter', 'latex', 'fontname', 'times new roman',...
        'fontsize', 16);
    ylabel('$\rm{log_{10}}{||\it{\varepsilon(\it{\theta_{\rm{3}}})}||_{\it{L}_{\rm{2}}}}$', 'interpreter', 'latex', 'fontname', 'times new roman',...
        'fontsize', 16)
    set(gca, 'fontname', 'times new roman', 'fontsize', 16, 'xminortick', 'on', 'yminortick', 'on')
p1 = polyfit(log10(dx(:,j)), log10(ErrW3(:,j)), 1)

end
if(gOrder==1)
    lgds = {
        '$m=1$', '$m=2$', '$m=3$', '$m=4$', '$m=5$'
        };
else
    lgds = {
        '$m=2$', '$m=3$', '$m=4$', '$m=5$'
        };
end
if(gOrder==2)
    figure(1);
    axis equal
    xmin = -2.4;   xmax = -0.8; xinc = 0.4; xarr = xmin:xinc:xmax;
    ymin = -2.7;   ymax = -0.7; yinc = 0.5; yarr = ymin:yinc:ymax;
    axis([xmin, xmax, ymin, ymax])
    legend(lgds, 'interpreter', 'latex', 'Location', 'northwest');
    set(gca, 'xtick', xarr, 'ytick', yarr)
    figure(2);
    axis equal
    xmin = -2.5;   xmax = -0.5; xinc = 0.5; xarr = xmin:xinc:xmax;
    ymin = -2.3;   ymax = 0.2;  yinc = 0.5; yarr = ymin:yinc:ymax;
    axis([xmin, xmax, ymin, ymax])
    legend(lgds, 'interpreter', 'latex', 'Location', 'northwest');
    set(gca, 'xtick', xarr, 'ytick', yarr)
end