clc; clear
resultFolder = 'result\';
D = load([resultFolder,'FEMdata.mat'], 'data');
U1_fem = D.data.U1;
U2_fem = D.data.U2;
W3_fem = D.data.W3;
ndivs = [10, 20, 40, 60, 80, 100];
ErrU = zeros(numel(ndivs), 5);
ErrU2 = zeros(numel(ndivs), 5);
ErrW3 = zeros(numel(ndivs), 5);
dx = zeros(numel(ndivs), 5);
gOrder = 2;

for j = 1:numel(ndivs)
    
    fileName = [resultFolder,sprintf('Model_II_M_Conv_%dx%d_gOrder%d.mat', ndivs(j), ndivs(j), gOrder)];
    
    if(~exist(fileName, 'file'))
        continue;
    end
    A = load(fileName);
    modelData = A.Model_II_M_Conv;
    for i = 1:numel(modelData)
        if(isempty(modelData(i).result))
            continue;
        end
        result = modelData(i).result;
        X = result.X;
        Y = result.Y;
        VOL = result.VOL;
        U1 = result.U1;
        U2 = result.U2;
        W3 =  result.W3;
        mvalue = modelData(i).mvalue;
        ndiv =  modelData(i).ndiv;
        gfunOrder = modelData(i).gfunOrder;
        if(mvalue==3)
            figure(2*j-1); clf
            h = pcolor(X, Y, U2);
            set(h, 'edgecolor', 'k', 'linewidth', 0.1)
            colormap(jet(10))
            h = colorbar;
            set(h, 'Ticks', linspace(min(U2(:)), max(U2(:)), 11))
            axis([0,1,0,1]); axis equal; axis([0,1,0,1])
            
            xlabel('$x$', 'interpreter', 'latex', 'fontsize', 16, 'fontname', 'times new roman')
            ylabel('$y$', 'interpreter', 'latex', 'fontsize', 16, 'fontname', 'times new roman')
            titleText = sprintf('$\\it{u}_{\\rm{2}}:\\;\\rm{%d\\times%d}$', ndiv, ndiv);
            title(titleText, 'interpreter', 'latex', 'fontsize', 16, 'fontname', 'times new roman')
            set(gca, 'fontsize', 14, 'fontname', 'times new roman',...
                'xtick', 0:0.1:1, 'ytick', 0:0.1:1);
            
            figure(2*j); clf
            h = pcolor(X, Y, W3);
            set(h, 'edgecolor', 'k', 'linewidth', 0.1)
            colormap(jet(10))
            h = colorbar;
            set(h, 'Ticks', linspace(min(W3(:)), max(W3(:)), 11))
            axis([0,1,0,1]); axis equal; axis([0,1,0,1])
            xlabel('$x$', 'interpreter', 'latex', 'fontsize', 16, 'fontname', 'times new roman')
            ylabel('$y$', 'interpreter', 'latex', 'fontsize', 16, 'fontname', 'times new roman')
            titleText = sprintf('$\\it{\\theta}_{\\rm{3}}:\\;\\rm{%d\\times%d}$', ndiv, ndiv);
            title(titleText, 'interpreter', 'latex', 'fontsize', 16, 'fontname', 'times new roman')
            set(gca, 'fontsize', 14, 'fontname', 'times new roman',...
                'xtick', 0:0.1:1, 'ytick', 0:0.1:1);
        end
    end
end