clc; clear
figure(1); clf
load('PoissonRatioData.mat')
nu_arr = nu_true;
nu0_arr = -nu_calculated;

save PoissonRatioData nu_true nu_calculated
yyaxis left
plot(nu_arr, -nu0_arr, 'b-', 'linewidth',2)
xlabel('\fontname{song ti}指定泊松比 \fontname{times new roman}\nu_{t}',  'fontsize', 16)
ylabel('\fontname{song ti}计算泊松比 \fontname{times new roman}\nu_{p}','fontsize', 16)
set(gca,  'fontsize', 16, 'fontname', 'times new roman', ...
    'xtick', [-1:0.2:0.2,1/3], 'xticklabel', {'-1', '-0.8', '-0.6', '-0.4', '-0.2','0.0','-0.2', '1/3'} ,...
    'ytick', [-1:0.2:0.2,1/3], 'yticklabel', {'-1', '-0.8', '-0.6', '-0.4', '-0.2','0.0','-0.2', '1/3'})
axis([-1,1/3, -1, 1/3]); grid on
yyaxis right
plot(nu_arr, (-nu0_arr-nu_arr), 'r--', 'linewidth',2)
% xlabel('$\rm{Prescribed\;Poisson''s\;ratio}$', 'interpreter', 'latex', 'fontsize', 16, 'fontname', 'times new roman')
% ylabel('$\rm{Absolute\;error\;\nu_{p}-\nu_{t}}$', 'interpreter', 'latex', 'fontsize', 16, 'fontname', 'times new roman')
%xlabel('\fontname{song ti}指定泊松比',  'fontsize', 16)
ylabel('\fontname{song ti}绝对误差 \fontname{times new roman}\nu_{p}-\nu_{t}','fontsize', 16)