clc; clear
characteristicLength_Arr = 0.5 ;
linType = {'r-', 'k--', 'b-.'};
lgd = {'$\ell_{\rm{b}}=\rm{0.01m}$', '$\ell_{\rm{b}}=\rm{0.1m}$', '$\ell_{\rm{b}}=\rm{0.5m}$'};
for jj = 1:numel(characteristicLength_Arr)
    characteristicLength = characteristicLength_Arr(jj);
    resFolder = sprintf('tensile_crack_result\\lb_%gm\\', characteristicLength);
    timeSteps = 200;
    load([resFolder, 'init'])
    x = init.x;
    y = init.y;
    Rfxs = zeros(size(timeSteps));
    ApplyU2s = zeros(size(timeSteps));
    for i = 1:numel(timeSteps)
        step = timeSteps(i);
        load([resFolder,sprintf('step%d.mat',step)]);
            figure(200); clf
            h = imagesc(x(1,1:end), y(end:-1:1,1),reshape(step.dmg,size(x)));
            caxis([0,0.8])
            %set(h, 'edgecolor', 'none');
            colormap(jet(20)); colorbar; axis('equal')
            pause(0.01)
            figure(300); clf
            h =  imagesc(x(1,1:end), y(end:-1:1,1),reshape(step.W3,size(x)));
            
            %set(h, 'edgecolor', 'none');
            colormap(jet(20)); colorbar; axis('equal')
            pause(0.01)            
        ApplyU2s(i) = step.applyU2;
        Rfxs(i) = step.Rf1;
    end

    
end