clc; clear
characteristicLength_Arr = [0.01, 0.1, 0.5] ;
linType = {'r-', 'k--', 'b-.'};
lgd = {'$\ell_{\rm{b}}=\rm{0.01m}$', '$\ell_{\rm{b}}=\rm{0.1m}$', '$\ell_{\rm{b}}=\rm{0.5m}$'};
for jj = 1:numel(characteristicLength_Arr)
    characteristicLength = characteristicLength_Arr(jj);
    resFolder = sprintf('tensile_crack_result_finer_fixallrot\\lb_%gm\\', characteristicLength);
    timeSteps = 1:520;
    load([resFolder, 'init'])
    x = init.x;
    y = init.y;
    Rfxs = zeros(size(timeSteps));
    ApplyU2s = zeros(size(timeSteps));
    for i = 1:numel(timeSteps)
        step = timeSteps(i);
        load([resFolder,sprintf('step%d.mat',step)]);
        %     figure(200); clf
        %     h = pcolor(x,y,reshape(step.dmg,size(x)));
        %     set(h, 'edgecolor', 'none');
        %     colormap(jet(20)); colorbar; axis('equal')
        %     pause(0.01)
        ApplyU2s(i) = step.applyU2;
        Rfxs(i) = step.Rf1;
    end
    figure(100);hold on
    plot(ApplyU2s*1e3, Rfxs*1/100/(1/102), linType{jj}, 'linewidth',2)
    
end
box on
h = legend(lgd); set(h, 'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 14)
xlabel('$\rm{Displacement\; load}\;{\it{u}}_{\rm{y}}\;{(\rm{mm})}$', ...
    'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 14)
ylabel('$\rm{Reaction\;force}\;{\it{R}}_{\rm{y}}\;{(\rm{N})}$',...
    'interpreter', 'latex', 'fontname', 'times new roman', 'fontsize', 14)
set(gca,  'fontname', 'times new roman', 'fontsize', 14, ...
    'xtick', 0:1:5, 'ytick', 0:50:250, 'xminortick', 'on', 'yminortick', 'on')