clc; clear
P1 = load('crackSpeedData\4MPa.dat');
h1 = plot(P1(:,1), P1(:,2)+0.0003691, 'k-', 'linewidth', 2);
hold on
P2 = load('crackSpeedData\4MPa_OMPD_CN0P0.dat');
h2= plot(P2(:,1), P2(:,2), 'b-.', 'linewidth', 2);

P3 = load('crackSpeedData\4MPa_OMPD_CN0P5.dat');
h3 = plot(P3(:,1), P3(:,2), 'r:', 'linewidth', 2);


h4 = xline(9.3, 'k--');
h5 = xline(12.15, 'b--');
axis([0,40,0,1.0])


xlabel('$\rm{Time}{\rm{(\mu s)}}$', 'interpreter', 'latex', ...
    'fontsize', 16, 'fontname', 'times new roman')
ylabel('$v/c_{\rm{R}}$', 'interpreter', 'latex', ...
    'fontsize', 16, 'fontname', 'times new roman')
titleText1 = sprintf('\\rm{Bobaru\\fontname{song ti}和\\fontname{times new roman} Zhang }');
titleText2 = sprintf('\\rm{OMPD\\fontname{song ti}模型\\fontname{times new roman}-II }\\it{N}=\\rm{0} ');
titleText3 = sprintf('\\rm{OMPD\\fontname{song ti}模型\\fontname{times new roman}-II }\\it{N}=\\rm{0.5} ');

box on
set(gca, 'fontsize', 14, 'fontname', 'times new roman',...
    'xtick', 0:10:40, 'ytick', 0:0.2:1, ...
    'xminortick', 'on', 'yminortick', 'on');
legend({titleText1, titleText2, titleText3}, 'box', 'off' )
grid on
title(sprintf('\\sigma_0\\rm{=4MPa}'))
text(12.9, 0.1, sprintf('\\it{t}=\\rm{%g}\\rm{\\mu{s}}', 12.15), 'fontsize', 12, 'fontname', 'times new roman','rotation', 90)
text(9.9, 0.1, sprintf('\\it{t}=\\rm{%g}\\rm{\\mu{s}}', 9.3), 'fontsize', 12, 'fontname', 'times new roman','rotation', 90)
