clc; clear
P1 = load('other_numerical_res\2MPa.dat');
plot(P1(:,1), P1(:,2), 'k-', 'linewidth', 2)
hold on
P2 = load('other_numerical_res\2MPa_OMPD.dat');
plot(P2(:,1), P2(:,2), 'b-.', 'linewidth', 2)

P3 = load('other_numerical_res\2MPa_OMPD_CN0P5.dat');
plot(P3(:,1), P3(:,2), 'r:', 'linewidth', 2)



axis equal
axis([0,0.1,-0.02,0.02])


xlabel('$\it{x}{\rm{(m)}}$', 'interpreter', 'latex', ...
    'fontsize', 16, 'fontname', 'times new roman')
ylabel('$\it{y}{\rm{(m)}}$', 'interpreter', 'latex', ...
    'fontsize', 16, 'fontname', 'times new roman')
titleText1 = sprintf('\\rm{Bobaru and Zhang^{[67]} }\\it{t}=\\rm{%g}\\rm{\\mu{s}}', 43e-6*1e6);
titleText2 = sprintf('\\rm{OMPD model-II }\\it{N}=\\rm{0} \\it{t}=\\rm{%g}\\rm{\\mu{s}}', 43e-6*1e6);
titleText3 = sprintf('\\rm{OMPD model-II }\\it{N}=\\rm{0.5} \\it{t}=\\rm{%g}\\rm{\\mu{s}}', 35e-6*1e6);

box on
set(gca, 'fontsize', 14, 'fontname', 'times new roman',...
    'xtick', 0:0.02:0.1, 'ytick', -0.02:0.01:0.02, ...
    'xminortick', 'on', 'yminortick', 'on');
legend({titleText1, titleText2, titleText3}, 'box', 'off' )
title(sprintf('\\sigma_0\\rm{=2MPa}'))

