clc; clear
P1 = load('crackSpeedData\2MPa.dat');
h1 = plot(P1(:,1), P1(:,2)+0.0003691, 'k-', 'linewidth', 2);
hold on
P2 = load('crackSpeedData\2MPa_OMPD_CN0P0.dat');
h2= plot(P2(:,1), P2(:,2), 'b-.', 'linewidth', 2);

P3 = load('crackSpeedData\2MPa_OMPD_CN0P5.dat');
h3 = plot(P3(:,1), P3(:,2), 'r:', 'linewidth', 2);


h4 = xline(20.5, 'k--');
h5 = xline(27.4, 'b--');
axis([0,40,0,1.0])


xlabel('$\rm{Time}{\rm{(\mu s)}}$', 'interpreter', 'latex', ...
    'fontsize', 16, 'fontname', 'times new roman')
ylabel('$v/c_{\rm{R}}{\rm{(m)}}$', 'interpreter', 'latex', ...
    'fontsize', 16, 'fontname', 'times new roman')
titleText1 = sprintf('\\rm{Bobaru and Zhang [67]}');
titleText2 = sprintf('\\rm{OMPD model-II }\\it{N}=\\rm{0} ' );
titleText3 = sprintf('\\rm{OMPD model-II }\\it{N}=\\rm{0.5} ' );

box on
set(gca, 'fontsize', 14, 'fontname', 'times new roman',...
    'xtick', 0:10:40, 'ytick', 0:0.2:1, ...
    'xminortick', 'on', 'yminortick', 'on');
legend({titleText1, titleText2, titleText3}, 'box', 'off' )
grid on
title(sprintf('\\sigma_0\\rm{=2MPa}'))
text(21.5, 0.1, sprintf('\\it{t}=\\rm{%g}\\rm{\\mu{s}}', 20.5), 'fontsize', 12, 'fontname', 'times new roman','rotation', 90)
text(28.4, 0.1, sprintf('\\it{t}=\\rm{%g}\\rm{\\mu{s}}', 27.4), 'fontsize', 12, 'fontname', 'times new roman','rotation', 90)
