clc; clear;

% generate points
ndiv = 100;
[x, y] = meshgrid(linspace(0,1,ndiv+1));
dx = 1/ndiv;
coor = [x(:), y(:)];
%coor = coor + (rand(size(coor))-0.5)*dx;
delta = dx*3.015;
ratio = 1;
is2cell = 'no';
[ih, jh] = gridBasedNonUniformHorizonSearch(coor, delta, ratio, is2cell);
xi = coor(jh,:)-coor(ih,:);
bl = vecnorm(xi,2,2);
vc = (bl<delta-dx/2)*1 + (bl>delta-dx/2).*(delta-bl+dx/2)/dx;
vj = dx^2*vc;
wf = exp(-bl.^2/delta^2);
wfvj = wf.*vj;
XI = [xi(:,1).*xi(:,1), xi(:,2).*xi(:,2), xi(:,1).*xi(:,2)];
wfvjXI = [xi(:,1).*xi(:,1), xi(:,2).*xi(:,2), xi(:,1).*xi(:,2)].*repmat(wfvj,1,3);
np = size(coor,1);
ap = [0;find(diff(ih)==1); numel(ih)];
A  = arrayfun(@(i)XI(ap(i)+1:ap(i+1),:)'*wfvjXI(ap(i)+1:ap(i+1),:), (1:np)', 'uniform', 0);
a  = arrayfun(@(i)(inv(A{i})),(1:np)', 'uniform', 0);
g2  = cell2mat(arrayfun(@(i)wfvjXI(ap(i)+1:ap(i+1),:)*a{i},(1:np)', 'uniform', 0));

f = [1 * coor(:,1) + 2*coor(:,2), 3 * coor(:,1) + 4*coor(:,2)];
df = f(jh,:)-f(ih,:);
q20 = full(sparse(ih,1,df(:,1).*df(:,2).*g2(:,1)));
q02 = full(sparse(ih,1,df(:,1).*df(:,2).*g2(:,2)));
q11 = full(sparse(ih,1,df(:,1).*df(:,2).*g2(:,3)));

XI = [xi(:,1), xi(:,2)];
wfvjXI = [xi(:,1), xi(:,2)].*repmat(wfvj,1,2);
np = size(coor,1);
ap = [0;find(diff(ih)==1); numel(ih)];
A  = arrayfun(@(i)XI(ap(i)+1:ap(i+1),:)'*wfvjXI(ap(i)+1:ap(i+1),:), (1:np)', 'uniform', 0);
a  = arrayfun(@(i)(inv(A{i})),(1:np)', 'uniform', 0);
g1  = cell2mat(arrayfun(@(i)wfvjXI(ap(i)+1:ap(i+1),:)*a{i},(1:np)', 'uniform', 0));
f = [1 * coor(:,1) + 2*coor(:,2), 3 * coor(:,1) + 4*coor(:,2)];
theta = full(sparse(ih,1,g1(:,1).*df(:,1) + g1(:,2).*df(:,2)));


g11 = 3 * g2(:,1) + g2(:,2);
g12 = g2(:,3);
g21 = g12;
g22 = 3 * g2(:,2) + g2(:,1);

B = + sparse(ih, 2*jh-1, g1(:,1), np, 2*np) + sparse(ih, 2*jh, g1(:,2), np, 2*np) ...
    - sparse(ih, 2*ih-1, g1(:,1), np, 2*np) - sparse(ih, 2*ih, g1(:,2), np, 2*np);
D = + sparse(2*jh-1, 2*jh-1, g11, 2*np, 2*np) + sparse(2*jh-1, 2*jh, g12, 2*np, 2*np) ...
    + sparse(2*jh  , 2*jh-1, g21, 2*np, 2*np) + sparse(2*jh  , 2*jh, g22, 2*np, 2*np) ...
    - sparse(2*ih-1, 2*jh-1, g11, 2*np, 2*np) - sparse(2*ih-1, 2*jh, g12, 2*np, 2*np) ...
    - sparse(2*ih  , 2*jh-1, g21, 2*np, 2*np) - sparse(2*ih  , 2*jh, g22, 2*np, 2*np) ...
    - sparse(2*jh-1, 2*ih-1, g11, 2*np, 2*np) - sparse(2*jh-1, 2*ih, g12, 2*np, 2*np) ...
    - sparse(2*jh  , 2*ih-1, g21, 2*np, 2*np) - sparse(2*jh  , 2*ih, g22, 2*np, 2*np) ...
    + sparse(2*ih-1, 2*ih-1, g11, 2*np, 2*np) + sparse(2*ih-1, 2*ih, g12, 2*np, 2*np) ...
    + sparse(2*ih  , 2*ih-1, g21, 2*np, 2*np) + sparse(2*ih  , 2*ih, g22, 2*np, 2*np);

% g11 = 2 * g2(:,1);
% g12 = g2(:,3);
% g21 = g12;
% g22 = 2 * g2(:,2);
% q = (g11>0 & g22>0 & g11.*g22>g12.^2);
% all(q)

emod = 1;
nu   = 0.3;

nu = nu/(1+nu);
emod = emod*(1+nu^2);

lambda = nu*emod/(1-2*nu)/(1+nu);
mu     = emod/(2*(1+nu));

K = (lambda-mu)*(B'*B) + mu*D;
upNode   = find(coor(:,2)==1);
downNode = find(coor(:,2)==0);
leftNode = find(coor(:,1)==0);
G = [...
    sparse((1:numel(upNode)),   2*upNode, ones(size(upNode)),       numel(upNode),   2*np); ...
    sparse((1:numel(downNode)), 2*downNode, ones(size(downNode)),   numel(downNode), 2*np);...
    sparse((1:numel(leftNode)), 2*leftNode-1, ones(size(leftNode)), numel(leftNode), 2*np)];
F = zeros(2*np+size(G,1),1);
F(2*np+1:1:2*np+numel(upNode),1) = 1;
U = [K,G';G,sparse(size(G,1),size(G,1))]\F;
% opt = optimoptions('quadprog','Algorithm','interior-point-convex');
% U = quadprog(K,0*F(1:2*np,1),[],[], G, F(2*np+1:end,1), [],[], [], opt);
U1 = U(1:2:2*np);
U2 = U(2:2:2*np);
% scatter(coor(:,1), coor(:,2), 20, U1, 'filled')
h = pcolor(x,y,reshape(U2,size(x)));
set(h, 'edgecolor', 'none')
colormap(jet)
axis equal
colorbar



