function g = secondOrderGhatfun2D(xi, wfvj, ap)
XI = [xi(:,1).*xi(:,1), xi(:,2).*xi(:,2), xi(:,1).*xi(:,2)];
wfvjXI = [xi(:,1).*xi(:,1), xi(:,2).*xi(:,2), xi(:,1).*xi(:,2)].*repmat(wfvj,1,3);
np = numel(ap) - 1;
A  = arrayfun(@(i)XI(ap(i)+1:ap(i+1),:)'*wfvjXI(ap(i)+1:ap(i+1),:), (1:np)', 'uniform', 0);
a  = arrayfun(@(i)(inv(A{i})),(1:np)', 'uniform', 0);
g  = cell2mat(arrayfun(@(i)XI(ap(i)+1:ap(i+1),:)*a{i},(1:np)', 'uniform', 0));
end